/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathing;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathingWithTypesAirBreathing;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.ISelectiveVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.Vec3;

public class EntityWhale
extends EntityWaterMobPathingWithTypesAirBreathing
implements ISelectiveVariantTypes<EntityWaterMobPathing> {
    public int attacksLeft = 0;

    public EntityWhale(EntityType<? extends EntityWhale> entityType, Level worldIn) {
        super((EntityType<? extends EntityWaterMobPathingWithTypesAirBreathing>)entityType, worldIn);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new WhaleMeleeAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                return EntityWhale.this.f_19853_.m_46791_() != Difficulty.PEACEFUL && super.m_8036_();
            }
        });
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_11807_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11808_;
    }

    private boolean isNarwhal() {
        return "narwhal".equals(this.getVariantNameOrEmpty());
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(this.isNarwhal() ? this.m_21051_(Attributes.f_22281_).m_22135_() : 1.0));
        if (flag) {
            if (!this.isNarwhal()) {
                if (this.attacksLeft > 0) {
                    --this.attacksLeft;
                }
                if (entityIn instanceof Player) {
                    Player player = (Player)entityIn;
                    int ticks = 0;
                    if (this.f_19853_.m_46791_() == Difficulty.EASY) {
                        ticks = 50;
                    } else if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                        ticks = 100;
                    } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                        ticks = 140;
                    }
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, ticks, 1, false, false));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, ticks + 40, 1, false, false));
                }
            }
            Vec3 pos = this.m_20182_();
            Vec3 targetPos = entityIn.m_20182_();
            ((LivingEntity)entityIn).m_147240_(this.isNarwhal() ? (double)0.8f : 2.0, pos.f_82479_ - targetPos.f_82479_, pos.f_82481_ - targetPos.f_82481_);
        }
        return flag;
    }

    @Override
    public String[] getTypesFor(ResourceKey<Biome> biomeKey, Biome biome, Set<BiomeTypes.Type> types, MobSpawnType reason) {
        if (biomeKey == Biomes.f_48168_ || biomeKey == Biomes.f_48171_) {
            return new String[]{"bottlenose", "pilot"};
        }
        if (biomeKey == Biomes.f_48172_ || biomeKey == Biomes.f_48211_) {
            return new String[]{"narwhal", "beluga"};
        }
        if (biomeKey == Biomes.f_48170_ || biomeKey == Biomes.f_48225_) {
            return new String[]{"cuviers", "pilot"};
        }
        return new String[]{"cuviers", "pilot", "false_killer"};
    }

    @Override
    public EntityTypeContainer<? extends EntityWhale> getContainer() {
        return ModEntities.WHALE;
    }

    public static class WhaleMeleeAttackGoal
    extends MeleeAttackGoal {
        private final EntityWhale whale;

        public WhaleMeleeAttackGoal(EntityWhale whale) {
            super((PathfinderMob)whale, (double)1.2f, true);
            this.whale = whale;
        }

        public void m_8056_() {
            if (!this.whale.isNarwhal()) {
                this.whale.attacksLeft = 1;
            }
            super.m_8056_();
        }

        public boolean m_8045_() {
            return (this.whale.isNarwhal() || this.whale.attacksLeft > 0) && super.m_8045_();
        }

        protected void m_6739_(LivingEntity p_190102_1_, double p_190102_2_) {
            if (this.whale.attacksLeft > 0 || this.whale.isNarwhal()) {
                super.m_6739_(p_190102_1_, p_190102_2_);
            } else {
                this.m_8041_();
            }
        }

        public void m_8041_() {
            super.m_8041_();
            if (this.whale.attacksLeft <= 0 && !this.whale.isNarwhal()) {
                this.f_25540_.m_6710_(null);
            }
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + attackTarget.m_20205_();
        }
    }
}

